﻿/*
VERSION:		1.1
1.1:			Fix:  frames would stick when a setting was repeatedly set each frame (even if the setting stayed the same)
1.0:			Fully working, with no apparent bugs
0.0:			Replaced set_charset to use imageLoader & BitmapData
	
NOTE:
	This is sprite system 3.
	It's been modified from the previous version to use BitmapData instead of masking
	
DESCRIPTION:
	Pros:		Performance?  Able to directly use BitmapData as a charset input
	Cons:		Performance?
	
NOTE:
	This sprite system places the character's feet at the origin point.	(Feet:  1/2 image width, full image height)
	
	
USAGE:
	#include "functions/sprite.as"
	newSprite();			// minimum usage		(nothing is seen, but it can be modified later)
	
	
	#include "functions/sprite.as"
	var settings = {
		charset				:	"charset/marle.png",
		direction			:	2,				//(base zero)
		directions		:	4,				//(base one)		(amount of directions)
		frame					:	1,				//(base zero)
		frames				:	3,				//(base one)		(amount of frames)
		pose					:	0,				//(base zero)
		columns				:	4,				//(base zero)
		rows					:	2,				//(base zero)
		animType			:	"yoyo",
		animDirection	:	1,
		delay					:	3,				//(base one)
		isAnimating		:	true
	}
	mySprite = newSprite( settings, [parent], [instanceName], [depth] );			// maximum usage		(rm2k settings)
	
	
	mySprite.setParams({isAnimating:true});
	
	
	spriteState = mySprite.getParams();
	
	
DEFAULT SETTINGS:
	You can skip most settings when you setup a sprite.
	When you do, it defaults to these values:
		charset				:	REQUIRED
		direction			:	0
		directions		:	1
		frame					:	0
		frames				:	1
		pose					:	0
		columns				:	1
		rows					:	1
		animType			:	"loop"
		animDirection	:	1
		delay					:	4
		isAnimating		:	true
	
DEPENDANCIES:
	nextDepth.as

EVENTS:
	animDone			Broadcast after a "once" animation displays its last frame

DEPTHS:
	0		loader_mc_0
	1		loader_mc_1
	2		image_mc
*/



function newSprite( newSettings, newTarget, newName, newDepth )
{
	// resolve movieClip parameters
	// target
	var newTarget = (newTarget) ? newTarget : this;
	// name
	var newName = (newName) ? newName : "sprite_"+Math.floor(Math.random()*9999);
	while(newTarget[newName]){
		var newName = "sprite_"+Math.floor(Math.random()*9999);
	}// while:  this movieClip already exists
	// depth
	#include "nextDepth.as"
	var newDepth = (newDepth!=undefined) ? newDepth : nextDepth(newTarget);
	
	
	// create movieClip
	var _this = newTarget.createEmptyMovieClip( newName, newDepth );
	
	
	
	// create sprite sheet source
	_this.source_pic = new flash.display.BitmapData(1,1,true,0);
	_this.output_pic = new flash.display.BitmapData(2,2,true,0);
	_this.image_mc = _this.createEmptyMovieClip("image_mc", 2);
	
	
	
	AsBroadcaster.initialize( _this );
	
	// resolve optional parameters  &  copy settings
	var initSettings = {};
	// charset
	initSettings.charset = newSettings.charset;
	// direction
	initSettings.direction = (newSettings.direction!=undefined) ? newSettings.direction : 0;
	// directions
	initSettings.directions = (newSettings.directions!=undefined) ? newSettings.directions : 1;
	// frame
	initSettings.frame = (newSettings.frame!=undefined) ? newSettings.frame : 0;
	// frames
	initSettings.frames = (newSettings.frames!=undefined) ? newSettings.frames : 1;
	// pose
	initSettings.pose = (newSettings.pose!=undefined) ? newSettings.pose : 0;
	// columns
	initSettings.columns = (newSettings.columns!=undefined) ? newSettings.columns : 1;
	// rows
	initSettings.rows = (newSettings.rows!=undefined) ? newSettings.rows : 1;
	// animType
	initSettings.animType = (newSettings.animType!=undefined) ? newSettings.animType : "loop";
	// animDirection
	initSettings.animDirection = (newSettings.animDirection!=undefined) ? newSettings.animDirection : 1;
	// delay
	initSettings.delay = (newSettings.delay!=undefined) ? newSettings.delay : 4;
	// isAnimating
	initSettings.isAnimating = (newSettings.isAnimating!=undefined) ? newSettings.isAnimating : true;
	// charset MUST be defined
	
	
	// init settings
	_this.newSettings = {};
	_this.init = _this.newSettings;		// legacy support
	
	// internal settings
	_this.currentSettings = {};
	_this.currentSettings.frame = 0;
	_this.internal = _this.currentSettings;		// legacy support
	
	
	// spriteWidth & spriteHeight are initialized here, but will be derived upon loading
	_this.spriteWidth = 0;
	_this.spriteHeight = 0;
	
	
	// update flag
	_this.do_updateSize = true;
	_this.do_update = true;
	
	
	// chipset loader
	_this.loadDepth = 0;
	
	
	
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// SUPPORT FUNCTIONS
	_this.loadImage = function( file, done )
	{
		var imageLoaded = false;
		
		// remove previous loader
		_this.loader_mc.removeMovieClip();
		_this.loadDepth = Number(!_this.loadDepth);		// toggle between 0 & 1
		var newName = "loader_mc_"+_this.loadDepth;		// loader_mc_0
		_this.loader_mc = _this.createEmptyMovieClip(newName, _this.loadDepth);
		_this.loader_mc._visible = false;
		
		
		// bitmap linkage
		if(!imageLoaded){
			var image_pic = flash.display.BitmapData.loadBitmap( file );
			_this.loader_mc.attachBitmap(image_pic, 0, false, false);
			if(	_this.loader_mc._width > 0){
				var output_pic = new flash.display.BitmapData( _this.loader_mc._width, _this.loader_mc._height, true, 0 );
				output_pic.draw( _this.loader_mc );
				done( output_pic );
				imageLoaded = true;
			}// if:  success
		}// if:  prev attempt failed
		
		
		// // try movieClip linkage
		if(!imageLoaded){
			var newImage = _this.loader_mc.attachMovie( file, "attached_mc", 0 );
			if(	newImage._width > 0){
				var output_pic = new flash.display.BitmapData( newImage._width, newImage._height, true, 0 );
				output_pic.draw( newImage );
				done( output_pic );
				imageLoaded = true;
			}// if:  success
		}// if:  prev attempt failed
		
		
		// // direct bitmapData
		if(!imageLoaded){
			if(file.generateFilterRect != undefined){
				done( file.clone() );
				imageLoaded = true;
			}
		}// if:  prev attempt failed
		
		
		// external file
		if(!imageLoaded){
			var loader = new MovieClipLoader();
			loader.onLoadInit = function( loader_mc )
			{
				loader_mc._visible = false;
				var output_pic = new flash.display.BitmapData( loader_mc._width, loader_mc._height, true, 0 );
				output_pic.draw( loader_mc );
				done( output_pic );
				imageLoaded = true;
			}// loaded()
			loader.loadClip( file, _this.loader_mc );
		}// if:  prev attempt failed
	}// loadImage()
	
	
	
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// FUNCTIONS
	
	// update()		(using "internal" settings)
	// position image_mc
	_this.update = function()
	{
		// copy new frame to output_pic
		var column = _this.currentSettings.pose%_this.currentSettings.columns;
		var row = Math.floor(_this.currentSettings.pose/_this.currentSettings.columns);
		var xx = column*_this.spriteWidth*_this.currentSettings.frames  +  _this.currentSettings.frame*_this.spriteWidth;
		var yy = row*_this.spriteHeight*_this.currentSettings.directions  +  _this.currentSettings.direction*_this.spriteHeight;
		xx = Math.floor(xx);
		yy = Math.floor(yy);
		var copy_rect = new flash.geom.Rectangle( xx,yy, _this.spriteWidth,_this.spriteHeight );
		_this.output_pic.copyPixels( _this.source_pic, copy_rect, new flash.geom.Point(0,0) ); 
		// --------------------
		//updateAfterEvent();
		_this.do_update = false;
	}// update()
	
	
	
	
	
	// update image size & offset  And  update mask's size & offset
	_this.updateSize = function()
	{// requires:		image_mc,  mask_mc,  internal.columns,  internal.rows,  internal.frames,  internal.directions
		// update spriteWidth & spriteHeight
		_this.spriteWidth = _this.source_pic.width / _this.currentSettings.columns / _this.currentSettings.frames;
		_this.spriteHeight = _this.source_pic.height / _this.currentSettings.rows / _this.currentSettings.directions;
		_this.spriteWidth =  Math.floor(_this.spriteWidth);
		_this.spriteHeight =  Math.floor(_this.spriteHeight);
		// update image offset
		_this.image_mc._x = -_this.spriteWidth / 2;
		_this.image_mc._y = -_this.spriteHeight;
		// update output size
		_this.output_pic.dispose();
		_this.output_pic = new flash.display.BitmapData( _this.spriteWidth, _this.spriteHeight, true, 0 );
		// display new output
		_this.image_mc.attachBitmap( _this.output_pic, 0, true, false );
		
		_this.do_updateSize = false;
	}// updateSize()
	
	
	
	// charset
	_this.set_charset = function( new_charset, newThis, callback )
	{
		#include "nextDepth.as"
		var _this = newThis || _this;
		//_this.currentSettings.charset = new_charset;
		
		
		_this.loadImage( new_charset, function( output_pic ){
			// store it
			_this.source_pic = output_pic;
			
			// set update flag
			_this.do_updateSize = true;
			_this.do_update = true;
			// check & set other settings
			callback();
		});// loadImage() call
	}// set_charset()
	
	
	
	
	// directions
	_this.set_directions = function( new_directions )
	{
		// enforce minimum
		if(new_directions<0)
			var new_directions=1;
		// --------------
		_this.currentSettings.directions = Math.floor(Math.abs(Number(new_directions)));		// only positive integers
		_this.currentSettings.direction %= _this.currentSettings.directions;
		// --------------
		// immediately recalculate spriteWidth & spriteHeight  And  update the mask
		//_this.updateSize();
		_this.do_updateSize = true;
		// update the display this frame
		_this.do_update = true;
	}// set_directions()
	
	
	
	
	// direction
	_this.set_direction = function( new_direction )
	{
		// interpret clockwise english values  (works for RPGs, Platformers, Escape Velocity, etc...)
		var incr = _this.currentSettings.directions/4;
		if(new_direction=="up"){
			var new_direction = 0;
		}else if(new_direction=="right"){
			var new_direction = Math.floor(1*incr);
		}else if(new_direction=="down"){
			var new_direction = Math.floor(2*incr);
		}else if(new_direction=="left"){
			var new_direction = Math.floor(3*incr);
		}
		if(new_direction != _this.currentSettings.direction)
		{// if:  direction really is different from before
			// limit minimum to looping range
			while(new_direction < 0)
				new_direction += _this.currentSettings.directions;
			// loop the maximum
			new_direction %= _this.currentSettings.directions;
			// update the display this frame
			_this.do_update = true;
		}// if:  direction really is different from before
		// --------------
		_this.currentSettings.direction = _this.newSettings.direction = Math.floor(Number(new_direction));		// as an integer
	}// set_direction()
	
	
	
	
	// frames
	_this.set_frames = function( new_frames )
	{
		if(_this.currentSettings.frame > new_frames-1)
			_this.currentSettings.frame = new_frames-1;
		if(_this.newSettings.frame > new_frames-1)
			_this.newSettings.frame = new_frames-1;
		// --------------
		_this.currentSettings.frames = Math.floor(Math.abs(Number(new_frames)));		// only positive integers
		if(_this.currentSettings.frame > _this.currentSettings.frames-1)
			_this.currentSettings.frame = _this.currentSettings.frames-1;
		// --------------
		_this.newSettings.frame = _this.currentSettings.frame;
		// immediately recalculate spriteWidth & spriteHeight  And  update the mask
		//_this.updateSize();
		_this.do_updateSize = true;
		// update the display this frame
		_this.do_update = true;
	}// set_frames()
	
	
	
	
	// frame
	_this.set_frame = function( new_frame )
	{
		// enforce minimum
		if(new_frame < 0)
			var new_frame = 0;
		// enforce maximum
		if(new_frame > _this.currentSettings.frames-1)
			var new_frame = _this.currentSettings.frames-1;
		// update the display this frame
		_this.do_update = true;
		// --------------
		_this.newSettings.frame = _this.currentSettings.frame = Math.floor(Math.abs(Number(new_frame)));		// only positive integers
	}// set_frame()
	
	
	
	
	// columns
	_this.set_columns = function( new_columns )
	{
		_this.currentSettings.columns = Math.floor(Math.abs(Number(new_columns)));		// only positive integers
		// --------------
		// immediately recalculate spriteWidth & spriteHeight  And  update the mask
		//_this.updateSize();
		_this.do_updateSize = true;
		// update the display this frame
		_this.do_update = true;
	}// set_columns()
	
	
	
	
	// rows
	_this.set_rows = function( new_rows )
	{
		_this.currentSettings.rows = Math.floor(Math.abs(Number(new_rows)));		// only positive integers
		// --------------
		// immediately recalculate spriteWidth & spriteHeight  And  update the mask
		//_this.updateSize();
		_this.do_updateSize = true;
		// update the display this frame
		_this.do_update = true;
	}// set_rows()
	
	
	
	
	// pose
	_this.set_pose = function( new_pose )
	{
		var maxPose = (_this.currentSettings.columns*_this.currentSettings.rows)-1;
		// enforce minimum
		if(new_pose<0)
			var new_pose=0;
		// enforce maximum
		if(new_pose>maxPose)
			var new_pose=maxPose;
		// update the display this frame
		_this.do_update = true;
		// --------------
		_this.currentSettings.pose = Math.floor(Math.abs(Number(new_pose)));		// only positive integers
	}// set_pose()
	
	
	
	
	// animType
	_this.set_animType = function( new_animType )
	{
		// only allow valid values
		if(new_animType == "loop"
		|| new_animType == "yoyo"
		|| new_animType == "once")
			_this.currentSettings.animType = String(new_animType);
	}// set_animType()
	
	
	
	
	// animDirection
	_this.set_animDirection = function( new_animDirection )
	{
		// enforce minimum
		if(new_animDirection<-1)
			var new_animDirection=-1;
		// enforce maximum
		if(new_animDirection>1)
			var new_animDirection=1;
		// only allow valid values
		if(new_animDirection == -1
		|| new_animDirection == 1)
			_this.currentSettings.animDirection = Number(new_animDirection);
	}// set_animDirection()
	
	
	
	
	// delay
	_this.set_delay = function( new_delay )
	{
		// enforce minimum		(can be decimal, cannot be Zero)
		if(new_delay<=0)
			var new_delay=1;
		// --------------
		_this.currentSettings.delay = Number(new_delay);
	}// set_delay()
	
	
	
	
	// isAnimating
	_this.set_isAnimating = function( new_isAnimating )
	{
		// catch string versions of "true" and "false"
		if(new_isAnimating.toLowerCase() == "true")
			var new_isAnimating = true;
		if(new_isAnimating.toLowerCase() == "false")
			var new_isAnimating = false;
		if(Boolean(new_isAnimating) != _this.currentSettings.isAnimating)
		{// if:  changed
			if(new_isAnimating){
				// -> ON
				_this.advanceAnimation();
			}else{
				// -> OFF
				_this.currentSettings.frame = Number(_this.newSettings.frame);
			}
			// update the display this frame
			_this.do_update = true;
		}// if:  changed
		// --------------
		_this.currentSettings.isAnimating = Boolean(new_isAnimating);
	}// set_isAnimating()
	
	
	
	
	
	// setParams()
	_this.setParams = function( inputSettings )
	{
		for(var nam in inputSettings)
			_this.newSettings[nam] = inputSettings[nam];
		
		var setOtherSettings = function()
		{
			// currentSettings that are modified by the sprite system itself, should check for "inputSettings" changes instead of "newSettings"
			
			// directions
			if( _this.newSettings.directions != undefined
			&&	_this.newSettings.directions != _this.currentSettings.directions){
				_this.set_directions( _this.newSettings.directions );
				_this.currentSettings.directions = _this.newSettings.directions;
			}
			// direction
			if( _this.newSettings.direction != undefined
			&&	_this.newSettings.direction != _this.currentSettings.direction){
				_this.set_direction( _this.newSettings.direction );
				//_this.currentSettings.direction = _this.newSettings.direction;		// skip because direction must converted into a number
			}
			// frames
			if( _this.newSettings.frames != undefined
			&&	_this.newSettings.frames != _this.currentSettings.frames){
				_this.set_frames( _this.newSettings.frames );
				_this.currentSettings.frames = _this.newSettings.frames;
			}
			// frame
			if( inputSettings.frame != undefined
			&&	inputSettings.frame != _this.currentSettings.frame){
				_this.set_frame( _this.newSettings.frame );
				_this.currentSettings.frame = _this.newSettings.frame;
			}
			// columns
			if( _this.newSettings.columns != undefined
			&&	_this.newSettings.columns != _this.currentSettings.columns){
				_this.set_columns( _this.newSettings.columns );
				_this.currentSettings.columns = _this.newSettings.columns;
			}
			// rows
			if( _this.newSettings.rows != undefined
			&&	_this.newSettings.rows != _this.currentSettings.rows){
				_this.set_rows( _this.newSettings.rows );
				_this.currentSettings.rows = _this.newSettings.rows;
			}
			// pose
			if( _this.newSettings.pose != undefined
			&&	_this.newSettings.pose != _this.currentSettings.pose){
				_this.set_pose( _this.newSettings.pose );
				_this.currentSettings.pose = _this.newSettings.pose;
			}
			// animType
			if( _this.newSettings.animType != undefined
			&&	_this.newSettings.animType != _this.currentSettings.animType){
				_this.set_animType( _this.newSettings.animType );
				_this.currentSettings.animType = _this.newSettings.animType;
			}
			// animDirection
			if( inputSettings.animDirection != undefined
			&&	_this.newSettings.animDirection != _this.currentSettings.animDirection){
				_this.set_animDirection( _this.newSettings.animDirection );
				_this.currentSettings.animDirection = _this.newSettings.animDirection;
			}
			// delay
			if( _this.newSettings.delay != undefined
			&&	_this.newSettings.delay != _this.currentSettings.delay){
				_this.set_delay( _this.newSettings.delay );
				_this.currentSettings.delay = _this.newSettings.delay;
			}
			// isAnimating
			if( _this.newSettings.isAnimating != undefined
			&&	_this.newSettings.isAnimating != _this.currentSettings.isAnimating){
				_this.set_isAnimating( _this.newSettings.isAnimating );
				_this.currentSettings.isAnimating = _this.newSettings.isAnimating;
			}
			
			
			if(_this.do_updateSize){
				_this.updateSize();
			}
			
			if(_this.do_update){
				_this.update();		// update display position
			}
		}// setOtherSettings()
		
		
		// charset		(image_mc, mask_mc size, spriteWidth, spriteHeight)		(asynchronous)
		if( _this.newSettings.charset != undefined
		&&	_this.newSettings.charset != _this.currentSettings.charset){
			_this.set_charset( _this.newSettings.charset, null, setOtherSettings );
			_this.currentSettings.charset = _this.newSettings.charset;		// immediately store the new "charset" setting
		}// if:  changing charset
		else
		{// if:  not changing charset
			setOtherSettings();
		}// if:  not changing charset
	}// setParams()
	
	
	
	// getParams()
	_this.getParams = function()
	{
		// make a copy of the initial settings
		var output = {};
		for(var nam in _this.newSettings)
			output[nam] = _this.newSettings[nam];
		// return the copy
		return output;
	}// getParams()
	
	
	
	_this.getParam = function( varName )
	{
		return _this.currentSettings[varName];
	}// getParam()
	
	
	
	
	
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// LOOP
	
	// advanceAnimation()
	_this.advanceAnimation = function()
	{
		_this.currentSettings.frame += _this.currentSettings.animDirection;
		switch(_this.currentSettings.animType)
		{
			case "loop":
				// loop from minimum
				if(_this.currentSettings.frame<0){
					_this.currentSettings.frame += _this.currentSettings.frames;
				}
				// loop from maximum
				else if(_this.currentSettings.frame>=_this.currentSettings.frames){
					_this.currentSettings.frame -= _this.currentSettings.frames;
					_this.broadcastMessage("animDone");
					_this.animDone();
				}
			break;
			case "once":
				// limit to minimum
				if(_this.currentSettings.frame<0){
					_this.currentSettings.frame = 0;
				}
				// limit to maximum
				else if(_this.currentSettings.frame>=_this.currentSettings.frames){
					_this.currentSettings.frame = _this.currentSettings.frames-1;
					_this.broadcastMessage("animDone");
					_this.animDone();
				}
			break;
			case "yoyo":
				// reverse beyond minimum
				if(_this.currentSettings.frame<0){
					_this.currentSettings.frame += 2;						// undo last anim  &  advance in the opposite direction
					_this.currentSettings.animDirection *= -1;		// reverse animation direction
				}
				// reverse beyond maximum
				else if(_this.currentSettings.frame>=_this.currentSettings.frames){
					_this.currentSettings.frame -= 2;						// undo last anim  &  advance in the opposite direction
					_this.currentSettings.animDirection *= -1;		// reverse animation direction
					_this.broadcastMessage("animDone");
					_this.animDone();
				}
				
				// enforce max frame limit		(for sprites with only 1 frame of animation)
				if(_this.currentSettings.frame < 0)
					_this.currentSettings.frame = 0;
				if(_this.currentSettings.frame >= _this.currentSettings.frames)
					_this.currentSettings.frame = _this.currentSettings.frames-1;
			break;
		}// switch:  animType
	}// advanceAnimation()
	
	
	
	// loop()
	_this.fps = 30;
	_this.loop = function()
	{
		if(_this.currentSettings.isAnimating)
		{// if:  animation is on
			_this.advanceAnimation();
			_this.update();
		}// if:  animation is on
		//_this.update();
		_this.loopInterval = setTimeout( _this.loop, 1000/_this.fps*_this.newSettings.delay );
	}// loop()
	// this loop is started below, after setParams() is run
	
	
	
	
	
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// EXTRA FEATURES
	
	_this.lookAtCoords = function()
	{
		var destX = arguments[0];
		var destY = arguments[1];
		// get a unit vector
		var xDiff = destX - _this._parent._x;
		var yDiff = destY - _this._parent._y;
		var dist = Math.sqrt( xDiff*xDiff + yDiff*yDiff );
		var xUnit = xDiff / dist;
		var yUnit = yDiff / dist;
		
		// compare x & y
		if( Math.abs(yUnit) > Math.abs(xUnit) )
		{
			// vert
			if( yUnit < 0)
			{
				// up
				_this.setParams( {direction:"up"} );
			}else{
				// down
				_this.setParams( {direction:"down"} );
			}// if:  up or down
		}else{
			// horz
			if( xUnit < 0 )
			{
				// left
				_this.setParams( {direction:"left"} );
			}else{
				// right
				_this.setParams( {direction:"right"} );
			}// if:  left or right
		}// if:  vert or horz
	}// lookAtCoords()
	
	
	
	_this.lookAtSprite = function( sprite2 ){
		_this.lookAtCoords( sprite2._x, sprite2._y );
	}// lookAtSprite()
	
	
	
	// This makes the specified sprite look at another sprite.
	_this.lookAt = function( sprite1, sprite2 )
	{
		// get a unit vector
		var xDiff = sprite2._x - sprite1._x;
		var yDiff = sprite2._y - sprite1._y;
		var dist = Math.sqrt( xDiff*xDiff + yDiff*yDiff );
		var xUnit = xDiff / dist;
		var yUnit = yDiff / dist;
		
		// compare x & y
		if( Math.abs(yUnit) > Math.abs(xUnit) )
		{
			// vert
			if( yUnit < 0)
			{
				// up
				_this.setParams( {direction:"up"} );
			}else{
				// down
				_this.setParams( {direction:"down"} );
			}// if:  up or down
		}else{
			// horz
			if( xUnit < 0 )
			{
				// left
				_this.setParams( {direction:"left"} );
			}else{
				// right
				_this.setParams( {direction:"right"} );
			}// if:  left or right
		}// if:  vert or horz
	}// lookAt()
	
	
	
	_this.isFacing = function( checkDir )
	{
		var incr = _this.currentSettings.directions/4;
		if(checkDir=="up"){
			var checkDir = 0;
		}else if(checkDir=="right"){
			var checkDir = Math.floor(1*incr);
		}else if(checkDir=="down"){
			var checkDir = Math.floor(2*incr);
		}else if(checkDir=="left"){
			var checkDir = Math.floor(3*incr);
		}
		// limit minimum to looping range
		while(checkDir < 0)
			checkDir += _this.currentSettings.directions;
		// loop the maximum
		checkDir %= _this.currentSettings.directions;
		return (_this.currentSettings.direction == checkDir);
	}// isFacing()
	
	
	
	
	
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// SETUP
	
	
	
	// apply initial settings
	_this.setParams( initSettings );
	_this.loop();
	
	
	
	
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// ______________________________________________________________________________________________________________________
	// CLEAN-UP
	_this.onUnload = function()
	{
		clearTimeout( _this.loopInterval );
		// clear events
		for(var i in _this._listeners)
			_this._listeners[i] = null;
		_this._listeners = [];
	}// onUnload()
	
	
	
	
	
	// ______________________________________________________________________________________________________________________
	// return a reference
	return _this;
}// newSprite()